package ru.yandex.direct.bannersystem.container.masterreport.converter

/**
 * Большинство полей мы запрашиваем напрямую из БК, но некоторые вычисляем из других,
 * потому что в БК нет нужного нам поля
 *
 * В этом файле хранятся методы, по которым можно вычислить нужные поля
 */

fun calcDepth(sessionNumLimited: Long?, sessionNum: Long?, sessionDepth: Long?, clicks: Long?): Double? {
    if (clicks == null || sessionDepth == null) {
        return null
    }
    val num = (sessionNumLimited ?: sessionNum) ?: return null
    if (num == 0L) {
        return 0.0
    }
    return sessionDepth.toDouble() / num
}
