package ru.yandex.direct.bannersystem.container.masterreport.dict

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue

enum class CampaignPlatform(@JsonValue val id: Int) {
    SEARCH(1),
    CONTEXT(2),
    ;

    companion object {
        @JvmStatic
        @JsonCreator
        fun fromId(id: String) = values().find { it.id == id.toInt() }
    }

}
