package ru.yandex.direct.bannersystem.handle;

import javax.annotation.ParametersAreNonnullByDefault;

import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import org.apache.http.entity.ContentType;

import ru.yandex.direct.bannersystem.BsHostType;

/**
 * Описание основных характеристик ручки БК: путь к ней, хост, на котором она доступна, и наличие/отсутствие препрода
 */
@ParametersAreNonnullByDefault
public abstract class BsHandleSpec<T, P> {
    private final String urlPath;
    private final String handleName;
    private final BsHostType hostType;
    private final boolean hasPreProd;

    public BsHandleSpec(String urlPath, BsHostType hostType, boolean hasPreProd) {
        this.urlPath = urlPath;
        this.hostType = hostType;
        this.hasPreProd = hasPreProd;

        handleName = urlPath.replace("/", "_").replace(".cgi", "");
    }

    /**
     * Получить строковое название ручки
     */
    public String getHandleName() {
        return handleName;
    }

    public String getUrlPath() {
        return urlPath;
    }

    public BsHostType getHostType() {
        return hostType;
    }

    public boolean hasPreProd() {
        return hasPreProd;
    }

    public abstract String serializeRequestBody(T bodyObj);

    public abstract P deserializeResponseBody(String responseBody);

    public abstract ContentType getRequestContentType();

    public HttpHeaders getAdditionalHeaders() {
        return EmptyHttpHeaders.INSTANCE;
    }
}
