package ru.yandex.direct.bannersystem.handle;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.http.entity.ContentType;

import ru.yandex.direct.bannersystem.BsHostType;
import ru.yandex.direct.bannersystem.exception.BsClientException;
import ru.yandex.direct.utils.JsonUtils;

import static org.apache.http.entity.ContentType.APPLICATION_FORM_URLENCODED;


/**
 * Ручка в БК, принимающая JSON-данные в поле формы POSTDATA и отдающая результаты в JSON
 */
@ParametersAreNonnullByDefault
public class BsJsonFormHandleSpec<T, P> extends BsHandleSpec<T, P> {
    private final Class<P> responseClass;

    public BsJsonFormHandleSpec(String urlPath, BsHostType hostType, boolean hasPreProd,
                                 @Nullable Class<P> responseClass) {
        super(urlPath, hostType, hasPreProd);

        this.responseClass = responseClass;
    }

    @Override
    public String serializeRequestBody(Object bodyObj) {
        String json = JsonUtils.toJson(bodyObj);
        try {
            return "POSTDATA=" + URLEncoder.encode(json, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new BsClientException(e);
        }
    }

    @Override
    public P deserializeResponseBody(String responseBody) {
        if (responseClass != null) {
            return JsonUtils.fromJson(responseBody, responseClass);
        } else {
            throw new IllegalStateException("type or class not provided");
        }
    }

    @Override
    public ContentType getRequestContentType() {
        return ContentType.create(APPLICATION_FORM_URLENCODED.getMimeType());
    }
}
