package ru.yandex.direct.bannersystem.model.exporttable;

import java.util.regex.Pattern;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.direct.bannersystem.container.exporttable.BsTableRecord;

@JsonIgnoreProperties(ignoreUnknown = true)
public class UniwordRecord extends BsTableRecord {
    @JsonProperty("Options")
    private String options;

    @JsonProperty("Data")
    private String data;

    private static final Pattern STOP_PATTERN = Pattern.compile("(^|,)stop(,|$)");

    public UniwordRecord() {
    }

    public UniwordRecord(String data, String options) {
        this.data = data;
        this.options = options;
    }


    public boolean isStopWord() {
        return options != null
                && STOP_PATTERN.matcher(options).find()
                && StringUtils.isNotEmpty(data);
    }

    public String getStopWord() {
        return isStopWord() ? data : null;
    }
}

