package ru.yandex.direct.binlogclickhouse;

import ru.yandex.direct.utils.AsyncConsumer;
import ru.yandex.direct.utils.Interrupts;

public class AsyncInserter implements Inserter, AutoCloseable {
    private AsyncConsumer<BinlogTransactionsBatch> transactionsBatchConsumer;

    public AsyncInserter(Inserter inserter, int capacity) {
        this.transactionsBatchConsumer = new AsyncConsumer<>(inserter::insert, capacity, "AsyncInserter");
    }

    @Override
    public void insert(BinlogTransactionsBatch batch) {
        Interrupts.failingRun(() -> transactionsBatchConsumer.accept(batch));
    }

    @Override
    public void close() {
        transactionsBatchConsumer.close();
    }
}
