package ru.yandex.direct.binlogclickhouse;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import ru.yandex.direct.binlogclickhouse.schema.DbChangeLogRecord;
import ru.yandex.direct.binlogclickhouse.schema.QueryLogRecord;
import ru.yandex.direct.mysql.MySQLGtid;
import ru.yandex.direct.tracing.data.DirectTraceInfo;
import ru.yandex.direct.utils.Counter;

public class BinlogTransaction {
    private String gtid;
    private List<DbChangeLogRecord> changes;
    private List<QueryLogRecord> queries;
    private Counter changeSeqNumCounter;
    private Counter querySeqNumCounter;

    public BinlogTransaction(String gtid) {
        this.gtid = gtid;
        this.changes = new ArrayList<>();
        this.queries = new ArrayList<>();
        this.changeSeqNumCounter = new Counter();
        this.querySeqNumCounter = new Counter();
    }

    public String getGtid() {
        return gtid;
    }

    public List<DbChangeLogRecord> getChanges() {
        return Collections.unmodifiableList(changes);
    }

    public List<QueryLogRecord> getQueries() {
        return Collections.unmodifiableList(queries);
    }

    public BinlogTransactionChangeAdder addQuery(DirectTraceInfo directTraceInfo, String source, LocalDateTime dateTime,
                                                 String query) {
        MySQLGtid gtidObj = MySQLGtid.of(gtid);
        QueryLogRecord queryLogRecord = new QueryLogRecord(
                directTraceInfo, source, gtid, gtidObj.getSrc(), gtidObj.getScn(),
                querySeqNumCounter.next(), dateTime, query
        );
        if (!query.isEmpty()) {
            queries.add(queryLogRecord);
        }
        return new BinlogTransactionChangeAdder(queryLogRecord, changes, changeSeqNumCounter);
    }
}
