package ru.yandex.direct.binlogclickhouse;

import java.util.List;

import ru.yandex.direct.binlogclickhouse.schema.DbChangeLogRecord;
import ru.yandex.direct.binlogclickhouse.schema.FieldValueList;
import ru.yandex.direct.binlogclickhouse.schema.Operation;
import ru.yandex.direct.binlogclickhouse.schema.QueryLogRecord;
import ru.yandex.direct.utils.Counter;

public class BinlogTransactionChangeAdder {
    private QueryLogRecord queryLogRecord;
    private List<DbChangeLogRecord> changes;
    private Counter changeSeqNumCounter;

    public BinlogTransactionChangeAdder(
            QueryLogRecord queryLogRecord, List<DbChangeLogRecord> changes, Counter changeSeqNumCounter
    ) {
        this.queryLogRecord = queryLogRecord;
        this.changes = changes;
        this.changeSeqNumCounter = changeSeqNumCounter;
    }

    public void addChange(
            String db,
            String table,
            Operation operation,
            FieldValueList primaryKey,
            FieldValueList row
    ) {
        changes.add(new DbChangeLogRecord(
                queryLogRecord.getDirectTraceInfo(),
                queryLogRecord.getSource(),
                db,
                table,
                operation,
                queryLogRecord.getGtid(),
                queryLogRecord.getGtidSrc(),
                queryLogRecord.getGtidScn(),
                queryLogRecord.getQuerySeqNum(),
                changeSeqNumCounter.next(),
                primaryKey,
                queryLogRecord.getDateTime(),
                row
        ));
    }
}
