package ru.yandex.direct.binlogclickhouse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import ru.yandex.direct.binlog.reader.BinlogStateSet;
import ru.yandex.direct.binlog.reader.NamedBinlogState;
import ru.yandex.direct.mysql.MySQLBinlogState;

public class BinlogTransactionsBatch {
    private final List<BinlogTransaction> transactions;
    private BinlogStateSet stateSet;

    public BinlogTransactionsBatch() {
        transactions = new ArrayList<>();
        stateSet = new BinlogStateSet();
    }

    public BinlogTransactionsBatch(BinlogStateSet stateSet) {
        this.stateSet = stateSet;
        this.transactions = new ArrayList<>();
    }

    public BinlogTransactionsBatch(String source, MySQLBinlogState state, BinlogTransaction transaction) {
        this();
        transactions.add(transaction);
        stateSet.add(new NamedBinlogState(source, state));
    }

    public List<BinlogTransaction> getTransactions() {
        return Collections.unmodifiableList(transactions);
    }

    public BinlogStateSet getStateSet() {
        return stateSet;
    }

    public boolean isEmpty() {
        return transactions.isEmpty() && stateSet.isEmpty();
    }

    public int size() {
        return transactions.size();
    }

    public void add(BinlogTransactionsBatch newTransactions) {
        transactions.addAll(newTransactions.getTransactions());
        stateSet.addAll(newTransactions.stateSet);
    }

    public BinlogStateSet popStateSet() {
        try {
            return stateSet;
        } finally {
            stateSet = new BinlogStateSet();
        }
    }
}
