package ru.yandex.direct.binlogclickhouse;

import java.time.Duration;

import ru.yandex.direct.utils.MonotonicTime;
import ru.yandex.direct.utils.NanoTimeClock;

public class BufferedInserter implements Inserter, AutoCloseable {
    private Inserter inserter;
    private Duration flushTimeout;
    private int maxTransactions;

    private MonotonicTime lastFlush;
    private BinlogTransactionsBatch transactions;

    public BufferedInserter(Inserter inserter, Duration flushTimeout, int maxTransactions) {
        this.inserter = inserter;
        this.flushTimeout = flushTimeout;
        this.maxTransactions = maxTransactions;

        this.lastFlush = NanoTimeClock.now();
        this.transactions = new BinlogTransactionsBatch();
    }

    @Override
    public void insert(BinlogTransactionsBatch newTransactions) {
        transactions.add(newTransactions);
        if (transactions.size() >= maxTransactions || (lastFlush.plus(flushTimeout).isBefore(NanoTimeClock.now()))) {
            flush();
        }
    }

    public void flush() {
        if (!transactions.isEmpty()) {
            inserter.insert(transactions);
            clear();
        }
        lastFlush = NanoTimeClock.now();
    }

    public void clear() {
        transactions = new BinlogTransactionsBatch();
    }

    @Override
    public void close() {
        flush();
    }
}
