// TODO akimov@: мониторинг дублей (грепать сообщения в error.log кликхауса)

package ru.yandex.direct.binlogclickhouse;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Duration;
import java.util.List;

import ru.yandex.direct.binlog.reader.BinlogStateSnapshotter;
import ru.yandex.direct.mysql.AsyncStreamer;
import ru.yandex.direct.mysql.MySQLBinlogDataStreamer;
import ru.yandex.direct.mysql.MySQLSimpleConnector;
import ru.yandex.direct.utils.Transient;

public class DbChangeLogWriterBuilder {
    private final Inserter inserter;
    private final BinlogStateGetter binlogState;
    private final List<NamedBinlogProvider> mysqlProviders;
    private final BinlogStateSnapshotter snapshotter;
    private final Duration timeLimit;

    public DbChangeLogWriterBuilder(Inserter inserter, BinlogStateGetter binlogState,
                                    List<NamedBinlogProvider> mysqlProviders,
                                    BinlogStateSnapshotter snapshotter) {
        this(inserter, binlogState, mysqlProviders, snapshotter, null);
    }

    public DbChangeLogWriterBuilder(Inserter inserter, BinlogStateGetter binlogState,
                                    List<NamedBinlogProvider> mysqlProviders,
                                    BinlogStateSnapshotter snapshotter,
                                    Duration timeLimit) {
        this.inserter = inserter;
        this.binlogState = binlogState;
        this.mysqlProviders = mysqlProviders;
        this.snapshotter = snapshotter;
        this.timeLimit = timeLimit;
    }

    public DbChangeLogWriter build() throws IOException, SQLException {
        try (Transient<DbChangeLogWriter> writer = new Transient<>()) {
            writer.item = new DbChangeLogWriter(inserter, new AsyncStreamer.ExitMonitor(mysqlProviders.size()));
            for (NamedBinlogProvider provider : mysqlProviders) {
                writer.item.addAsyncStreamer(
                        provider.getName(),
                        new MySQLBinlogDataStreamer(
                                provider.getProvider(),
                                binlogState.getLastState(provider.getName()).orElseGet(() -> snapshotter.snapshot(
                                        new MySQLSimpleConnector(
                                                provider.getProvider().getHost(),
                                                provider.getProvider().getPort(),
                                                provider.getProvider().getUsername(),
                                                provider.getProvider().getPassword()
                                        )
                                ))
                        ),
                        provider.getSchemaReplicationMysql(),
                        timeLimit
                );
            }
            return writer.pop();
        }
    }
}
