package ru.yandex.direct.binlogclickhouse;

import java.time.Duration;

public class FlushInserter implements Inserter {
    private FlushableInserter inserter;
    private long maxTransactions;
    private Duration batchDuration;
    private long transactionsCount;
    private long lastFlushTime = 0;

    public FlushInserter(FlushableInserter inserter, long maxTransactions, Duration batchDuration) {
        this.inserter = inserter;
        this.maxTransactions = maxTransactions;
        this.batchDuration = batchDuration;
        this.transactionsCount = 0;
    }

    @Override
    public void insert(BinlogTransactionsBatch transactions) {
        long now = System.currentTimeMillis();
        if (lastFlushTime == 0) {
            lastFlushTime = now;
        }

        inserter.insert(transactions);
        transactionsCount += transactions.size();

        if (transactionsCount >= maxTransactions || now > lastFlushTime + batchDuration.toMillis()) {
            inserter.flush();
            this.transactionsCount = 0;
            this.lastFlushTime = now;
        }
    }
}
