package ru.yandex.direct.binlogclickhouse;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

import ru.yandex.direct.binlog.reader.BinlogStateSet;
import ru.yandex.direct.binlog.reader.StateBound;

public class StateBoundBufferedConsumer<T> implements Consumer<StateBound<List<T>>> {
    private final Consumer<StateBound<List<T>>> writer;
    private final int size;
    private BinlogStateSet stateSet;
    private List<T> items;

    public StateBoundBufferedConsumer(Consumer<StateBound<List<T>>> writer, int size) {
        this.writer = writer;
        this.size = size;
        this.stateSet = new BinlogStateSet();
        this.items = new ArrayList<>();
    }

    @Override
    public synchronized void accept(StateBound<List<T>> newActions) {
        stateSet.addAll(newActions.getStateSet());
        items.addAll(newActions.getData());
        if (items.size() >= size) {
            flush();
        }
    }

    private synchronized void flush() {
        writer.accept(new StateBound<>(stateSet, items));
        stateSet = new BinlogStateSet();
        items = new ArrayList<>();
    }
}
