package ru.yandex.direct.binlogclickhouse.schema;

import java.sql.Connection;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Optional;

import ru.yandex.direct.clickhouse.SimpleField;
import ru.yandex.direct.clickhouse.TableSchema;
import ru.yandex.direct.clickhouse.types.DateClickHouseType;
import ru.yandex.direct.clickhouse.types.DateTimeClickHouseType;
import ru.yandex.direct.clickhouse.types.IntegerClickHouseType;
import ru.yandex.direct.clickhouse.types.OptionalStringClickHouseType;
import ru.yandex.direct.clickhouse.types.StringClickHouseType;

public class BinlogStateSchema extends TableSchema {
    public static final SimpleField<String> SOURCE =
            new SimpleField<>("source", new StringClickHouseType());
    public static final SimpleField<LocalDate> DATE =
            new SimpleField<>("date", new DateClickHouseType());
    public static final SimpleField<LocalDateTime> DATETIME =
            new SimpleField<>("datetime", new DateTimeClickHouseType());
    public static final SimpleField<Optional<String>> STATE =
            new SimpleField<>("state", new OptionalStringClickHouseType(""));
    public static final SimpleField<Integer> COLLAPSING_SIGN =
            new SimpleField<>("collapsing_sign", new IntegerClickHouseType("Int8 DEFAULT 1"));

    public BinlogStateSchema(String dbName, String tableName) {
        super(
                dbName,
                tableName,
                Arrays.asList(
                        SOURCE,
                        DATE,
                        DATETIME,
                        STATE,
                        COLLAPSING_SIGN
                ),
                "CollapsingMergeTree",
                Arrays.asList(
                        DATE.getName(),
                        "(" + SOURCE.getName() + ", " + DATE.getName() + ")",
                        "1024",
                        COLLAPSING_SIGN.getName()
                )
        );
    }

    public BinlogStateTable connect(Connection conn) {
        return new BinlogStateTable(conn, getDbName(), getTableName());
    }
}
