package ru.yandex.direct.binlogclickhouse.schema;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.binlog.reader.MySQLSimpleRowIndexed;
import ru.yandex.direct.mysql.MySQLColumnData;
import ru.yandex.direct.mysql.schema.KeyColumn;
import ru.yandex.direct.mysql.schema.KeySchema;
import ru.yandex.direct.tracing.data.DirectTraceInfo;

public class DbChangeLogRecord {
    private final DirectTraceInfo directTraceInfo;
    private final String source;
    private final String db;
    private final String table;
    private final Operation operation;
    private final String gtid;
    private final String gtidSrc;
    private final long gtidScn;
    private final int querySeqNum;
    private final int changeSeqNum;
    private final FieldValueList primaryKey;
    private final LocalDateTime dateTime;
    private final FieldValueList row;

    @SuppressWarnings("checkstyle:parameternumber")
    public DbChangeLogRecord(
            DirectTraceInfo directTraceInfo,
            String source,
            String db,
            String table,
            Operation operation,
            String gtid,
            String gtidSrc,
            long gtidScn,
            int querySeqNum,
            int changeSeqNum,
            FieldValueList primaryKey,
            LocalDateTime dateTime,
            FieldValueList row
    ) {
        this.directTraceInfo = directTraceInfo;
        this.source = source;
        this.db = db;
        this.table = table;
        this.operation = operation;
        this.gtid = gtid;
        this.gtidSrc = gtidSrc;
        this.gtidScn = gtidScn;
        this.querySeqNum = querySeqNum;
        this.changeSeqNum = changeSeqNum;
        this.primaryKey = primaryKey;
        this.dateTime = dateTime;
        this.row = row;
    }

    public static FieldValueList makePrimaryKey(KeySchema key, MySQLSimpleRowIndexed row) {
        List<FieldValue<String>> keyFields = new ArrayList<>();

        for (KeyColumn keyColumn : key.getColumns()) {
            MySQLColumnData column = row.getByName(keyColumn.getName());
            keyFields.add(new FieldValue<>(
                    column.getSchema().getName(),
                    column.getValueAsString()
            ));
        }

        return new FieldValueList(keyFields);
    }

    public DirectTraceInfo getDirectTraceInfo() {
        return directTraceInfo;
    }

    public String getSource() {
        return source;
    }

    public String getDb() {
        return db;
    }

    public String getTable() {
        return table;
    }

    public Operation getOperation() {
        return operation;
    }

    public String getGtid() {
        return gtid;
    }

    public String getGtidSrc() {
        return gtidSrc;
    }

    public long getGtidScn() {
        return gtidScn;
    }

    public int getQuerySeqNum() {
        return querySeqNum;
    }

    public int getChangeSeqNum() {
        return changeSeqNum;
    }

    public FieldValueList getPrimaryKey() {
        return primaryKey;
    }

    public LocalDateTime getDateTime() {
        return dateTime;
    }

    public FieldValueList getRow() {
        return row;
    }

    @Override
    public String toString() {
        return "DbChangeLogRecord{" +
                "directTraceInfo=" + directTraceInfo +
                ", source='" + source + '\'' +
                ", db='" + db + '\'' +
                ", table='" + table + '\'' +
                ", operation=" + operation +
                ", gtid='" + gtid + '\'' +
                ", gtidSrc='" + gtidSrc + '\'' +
                ", gtidScn='" + gtidScn + '\'' +
                ", querySeqNum=" + querySeqNum +
                ", changeSeqNum=" + changeSeqNum +
                ", primaryKey=" + primaryKey +
                ", dateTime=" + dateTime +
                ", row=" + row +
                '}';
    }
}
