package ru.yandex.direct.binlogclickhouse.schema;

import java.time.LocalDateTime;

import ru.yandex.direct.tracing.data.DirectTraceInfo;

public class QueryLogRecord {
    private final DirectTraceInfo directTraceInfo;
    private final String source;
    private final String gtid;
    private final String gtidSrc;
    private final long gtidScn;
    private final int querySeqNum;
    private final LocalDateTime dateTime;
    private final String query;

    @SuppressWarnings("checkstyle:parameternumber")
    public QueryLogRecord(DirectTraceInfo directTraceInfo, String source,
                          String gtid, String gtidSrc, long gtidScn,
                          int querySeqNum, LocalDateTime dateTime, String query
    ) {
        this.directTraceInfo = directTraceInfo;
        this.source = source;
        this.gtid = gtid;
        this.gtidSrc = gtidSrc;
        this.gtidScn = gtidScn;
        this.querySeqNum = querySeqNum;
        this.dateTime = dateTime;
        this.query = query;
    }

    public DirectTraceInfo getDirectTraceInfo() {
        return directTraceInfo;
    }

    public String getSource() {
        return source;
    }

    public String getGtid() {
        return gtid;
    }

    public String getGtidSrc() {
        return gtidSrc;
    }

    public long getGtidScn() {
        return gtidScn;
    }

    public int getQuerySeqNum() {
        return querySeqNum;
    }

    public LocalDateTime getDateTime() {
        return dateTime;
    }

    public String getQuery() {
        return query;
    }

    @Override
    public String toString() {
        return "QueryLogRecord{" +
                "directTraceInfo=" + directTraceInfo +
                ", source='" + source + '\'' +
                ", gtid='" + gtid + '\'' +
                ", gtidSrc='" + gtidSrc + '\'' +
                ", gtidScn='" + gtidScn + '\'' +
                ", querySeqNum=" + querySeqNum +
                ", dateTime=" + dateTime +
                ", query='" + query + '\'' +
                '}';
    }
}
