package ru.yandex.direct.binlog.model;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

/**
 * Событие удаления колонки в таблице. Название таблицы - в {@link BinlogEvent#getTable()}.
 */
@ParametersAreNonnullByDefault
public class DropColumn implements SchemaChange {
    private String columnName;

    public String getColumnName() {
        return columnName;
    }

    public DropColumn withColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    @Override
    public DropColumn validate() {
        Preconditions.checkState(!StringUtils.isEmpty(columnName), "columnName is null");
        return this;
    }

    @Override
    public SchemaProtobuf.SchemaChange toProtobuf() {
        return SchemaProtobuf.SchemaChange.newBuilder()
                .setDropColumn(SchemaProtobuf.DropColumn.newBuilder()
                        .setColumName(getColumnName()))
                .build();
    }

    public static DropColumn fromProtobuf(SchemaProtobuf.SchemaChange protoSchemaChange) {
        SchemaProtobuf.DropColumn dropColumn = protoSchemaChange.getDropColumn();
        return new DropColumn().withColumnName(dropColumn.getColumName());
    }

    @Override
    public String toString() {
        return "DropColumn{" +
                "columnName='" + columnName + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DropColumn)) {
            return false;
        }
        DropColumn that = (DropColumn) o;
        return Objects.equals(columnName, that.columnName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(columnName);
    }
}
