package ru.yandex.direct.binlog.model;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Событие удаления таблицы. Название таблицы - в {@link BinlogEvent#getTable()}.
 */
@ParametersAreNonnullByDefault
public class DropTable implements SchemaChange<DropTable> {
    private final String tableName;

    public DropTable(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public DropTable validate() {
        return this;
    }

    @Override
    public SchemaProtobuf.SchemaChange toProtobuf() {
        var drop = SchemaProtobuf.DropTable.newBuilder();
        if (tableName != null) {
            drop.setTableName(tableName);
        }
        return SchemaProtobuf.SchemaChange.newBuilder()
                .setDropTable(drop)
                .build();
    }

    public static DropTable fromProtobuf(SchemaProtobuf.SchemaChange protoSchemaChange) {
        return new DropTable(protoSchemaChange.getDropTable().getTableName());
    }

    @Override
    public String toString() {
        return "DropTable{" +
                "tableName='" + tableName + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof DropTable;
    }

    @Override
    public int hashCode() {
        return 0;
    }
}
