package ru.yandex.direct.binlog.model;

public enum Operation {
    DELETE(true, false),
    INSERT(false, true),
    UPDATE(true, true),

    /**
     * DDL, изменение схемы таблиц
     */
    SCHEMA(false, false);


    private final boolean hasBefore;
    private final boolean hasAfter;

    Operation(boolean hasBefore, boolean hasAfter) {
        this.hasBefore = hasBefore;
        this.hasAfter = hasAfter;
    }

    public boolean hasBefore() {
        return hasBefore;
    }

    public boolean hasAfter() {
        return hasAfter;
    }
}
