package ru.yandex.direct.binlog.model;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface SchemaChange<T extends SchemaChange> {
    static SchemaChange fromProtobuf(SchemaProtobuf.SchemaChange protoSchemaChange) {
        Objects.requireNonNull(protoSchemaChange.getWhatCase(), "Invalid protoSchemaChange");
        switch (protoSchemaChange.getWhatCase()) {
            case CREATEORMODIFYCOLUMN:
                return CreateOrModifyColumn.fromProtobuf(protoSchemaChange);
            case CREATETABLE:
                return CreateTable.fromProtobuf(protoSchemaChange);
            case DROPCOLUMN:
                return DropColumn.fromProtobuf(protoSchemaChange);
            case DROPTABLE:
                return DropTable.fromProtobuf(protoSchemaChange);
            case RENAMECOLUMN:
                return RenameColumn.fromProtobuf(protoSchemaChange);
            case TRUNCATE:
                return Truncate.fromProtobuf(protoSchemaChange);
            case RENAMETABLE:
                return RenameTable.fromProtobuf(protoSchemaChange);
            default:
                throw new IllegalArgumentException("Don't know how to decode " + protoSchemaChange.getWhatCase());
        }
    }

    /**
     * Проверить объект на корректность и вернуть его же.
     */
    T validate();

    /**
     * Преобразовать объект в protobuf.
     */
    SchemaProtobuf.SchemaChange toProtobuf();
}
