package ru.yandex.direct.binlog.model;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Событие очистки таблицы. MySQL определяет это как DDL. Отличия от обычного "delete from table" значительны,
 * см. https://dev.mysql.com/doc/refman/5.7/en/truncate-table.html
 */
@ParametersAreNonnullByDefault
public class Truncate implements SchemaChange<Truncate> {
    public static Truncate fromProtobuf(SchemaProtobuf.SchemaChange protoSchemaChange) {
        return new Truncate();
    }

    @Override
    public Truncate validate() {
        return this;
    }

    @Override
    public SchemaProtobuf.SchemaChange toProtobuf() {
        return SchemaProtobuf.SchemaChange.newBuilder()
                .setTruncate(SchemaProtobuf.Truncate.newBuilder())
                .build();
    }

    @Override
    public String toString() {
        return "Truncate{}";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Truncate;
    }

    @Override
    public int hashCode() {
        return 0;
    }
}
