package ru.yandex.direct.binlog.reader;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;

import ru.yandex.direct.utils.db.MySQLConnector;

public class BinlogSource implements MySQLConnector {
    private final String name;
    private final MySQLConnector connector;

    /**
     * @param name      в качестве имени обычно используется имя шарда, так, каждая прочитанная транзакция помнит
     *                  из какого шарда она была прочитана. Это полезно, например, чтобы уметь сохранять на каком месте
     *                  бинлога мы закончили читать каждый шард и при рестарте продолжить чтение с этого места.
     * @param connector Коннектор, позволяющий подключиться к mysql-серверу источнику.
     */
    public BinlogSource(String name, MySQLConnector connector) {
        this.name = name;
        this.connector = connector;
    }

    public String getName() {
        return name;
    }

    public MySQLConnector getConnector() {
        return connector;
    }

    @Override
    public String getHost() {
        return connector.getHost();
    }

    @Override
    public int getPort() {
        return connector.getPort();
    }

    @Override
    public String getUsername() {
        return connector.getUsername();
    }

    @Override
    public String getPassword() {
        return connector.getPassword();
    }

    @Override
    public Connection connect() throws SQLException {
        return connector.connect();
    }

    @Override
    public Connection connect(Duration timeout) throws SQLException {
        return connector.connect(timeout);
    }

    @Override
    public String toString() {
        return "BinlogSource{" +
                "name='" + name + '\'' +
                ", connector=" + connector +
                '}';
    }
}
