package ru.yandex.direct.binlog.reader;

import java.sql.Connection;
import java.sql.SQLException;

import ru.yandex.direct.mysql.MySQLBinlogState;
import ru.yandex.direct.utils.Checked;
import ru.yandex.direct.utils.db.MySQLConnector;

public class BinlogStateUnsafeSnapshotter implements BinlogStateSnapshotter {
    @Override
    public MySQLBinlogState snapshot(MySQLConnector mysql) {
        try (Connection conn = mysql.connect()) {
            return MySQLBinlogState.snapshot(conn);
        } catch (SQLException exc) {
            throw new Checked.CheckedException(exc);
        }
    }
}
