package ru.yandex.direct.binlog.reader;

import java.time.LocalDateTime;
import java.util.Objects;

import ru.yandex.direct.mysql.schema.TableSchema;
import ru.yandex.direct.tracing.data.DirectTraceInfo;

public class EnrichedDeleteRow extends EnrichedRow {
    private final MySQLSimpleRowIndexed fields;

    public EnrichedDeleteRow(String gtid, String query, DirectTraceInfo directTraceInfo, int querySerial, int eventSerial,
                             int rowSerial, LocalDateTime dateTime, String dbName, String tableName, TableSchema tableSchema,
                             MySQLSimpleRowIndexed fields) {
        super(gtid, query, directTraceInfo, querySerial, eventSerial, rowSerial, dateTime, dbName, tableName, tableSchema);
        this.fields = fields;
    }

    public MySQLSimpleRowIndexed getFields() {
        return fields;
    }

    @Override
    public String toString() {
        return "EnrichedDeleteRow{" +
                "super=" +  super.toString() +
                ", fields=" + fields +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnrichedDeleteRow that = (EnrichedDeleteRow) o;
        return Objects.equals(fields, that.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), fields);
    }
}
