package ru.yandex.direct.binlog.reader;

import java.time.LocalDateTime;
import java.util.Objects;

import ru.yandex.direct.mysql.schema.TableSchema;
import ru.yandex.direct.tracing.data.DirectTraceInfo;

public class EnrichedInsertRow extends EnrichedRow {
    private final MySQLSimpleRowIndexed fields;

    public EnrichedInsertRow(String gtid, String query, DirectTraceInfo directTraceInfo, int querySerial, int eventSerial,
                             int rowSerial, LocalDateTime dateTime, String dbName, String tableName, TableSchema tableSchema,
                             MySQLSimpleRowIndexed fields) {
        super(gtid, query, directTraceInfo, querySerial, eventSerial, rowSerial, dateTime, dbName, tableName, tableSchema);
        this.fields = fields;
    }

    public MySQLSimpleRowIndexed getFields() {
        return fields;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EnrichedInsertRow insertRow = (EnrichedInsertRow) o;
        return Objects.equals(fields, insertRow.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(fields);
    }

    @Override
    public String toString() {
        return "EnrichedInsertRow{" +
                "fields=" + fields +
                '}';
    }
}
