package ru.yandex.direct.binlog.reader;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.StringJoiner;

import ru.yandex.direct.mysql.schema.TableSchema;
import ru.yandex.direct.tracing.data.DirectTraceInfo;

public abstract class EnrichedRow {
    private final String gtid;
    private final String query;
    private final DirectTraceInfo directTraceInfo;
    private final int querySerial;
    private final int eventSerial;
    private final int rowSerial;
    private final LocalDateTime dateTime;
    private final String dbName;
    private final String tableName;
    private final TableSchema tableSchema;

    public EnrichedRow(String gtid, String query, DirectTraceInfo directTraceInfo, int querySerial, int eventSerial,
                       int rowSerial, LocalDateTime dateTime, String dbName, String tableName, TableSchema tableSchema) {
        this.gtid = gtid;
        this.query = query;
        this.directTraceInfo = directTraceInfo;
        this.querySerial = querySerial;
        this.eventSerial = eventSerial;
        this.rowSerial = rowSerial;
        this.dateTime = dateTime;
        this.dbName = dbName;
        this.tableName = tableName;
        this.tableSchema = tableSchema;
    }

    public String getGtid() {
        return gtid;
    }

    public String getQuery() {
        return query;
    }

    public DirectTraceInfo getDirectTraceInfo() {
        return directTraceInfo;
    }

    public int getQuerySerial() {
        return querySerial;
    }

    public int getEventSerial() {
        return eventSerial;
    }

    public int getRowSerial() {
        return rowSerial;
    }

    public LocalDateTime getDateTime() {
        return dateTime;
    }

    public String getDbName() {
        return dbName;
    }

    public String getTableName() {
        return tableName;
    }

    public TableSchema getTableSchema() {
        return tableSchema;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EnrichedRow that = (EnrichedRow) o;
        return querySerial == that.querySerial &&
                rowSerial == that.rowSerial &&
                Objects.equals(gtid, that.gtid) &&
                Objects.equals(query, that.query) &&
                Objects.equals(directTraceInfo, that.directTraceInfo) &&
                Objects.equals(dateTime, that.dateTime) &&
                Objects.equals(dbName, that.dbName) &&
                Objects.equals(tableName, that.tableName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(gtid, query, directTraceInfo, querySerial, eventSerial, rowSerial, dateTime, dbName, tableName);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", EnrichedRow.class.getSimpleName() + "[", "]")
                .add("gtid='" + gtid + "'")
                .add("query='" + query + "'")
                .add("directTraceInfo=" + directTraceInfo)
                .add("querySerial=" + querySerial)
                .add("eventSerial=" + eventSerial)
                .add("rowSerial=" + rowSerial)
                .add("dateTime=" + dateTime)
                .add("dbName='" + dbName + "'")
                .add("tableName='" + tableName + "'")
                .add("tableSchema=" + tableSchema)
                .toString();
    }
}
