package ru.yandex.direct.binlog.reader;

import java.util.AbstractList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import ru.yandex.direct.mysql.MySQLColumnData;
import ru.yandex.direct.mysql.MySQLSimpleRow;

public class MySQLSimpleRowIndexed extends AbstractList<MySQLColumnData> {
    private Map<String, Integer> nameMap;
    private MySQLSimpleRow row;

    public MySQLSimpleRowIndexed(Map<String, Integer> nameMap, MySQLSimpleRow row) {
        this.nameMap = nameMap;
        this.row = row;
    }

    public MySQLColumnData getByNameNullable(String columnName) {
        Integer index = nameMap.get(columnName);
        if (index != null) {
            return row.get(index);
        } else {
            return null;
        }
    }

    public MySQLColumnData getByName(String columnName) {
        MySQLColumnData data = row.get(nameMap.get(columnName));
        if (data == null) {
            throw new IllegalArgumentException("Row does not contain field named " + columnName);
        } else {
            return data;
        }
    }

    public boolean hasName(String columnName) {
        return nameMap.containsKey(columnName);
    }

    public MySQLColumnData getLongByName(String columnName) {
        return row.get(nameMap.get(columnName));
    }

    public Map<String, String> toMap() {
        Map<String, String> result = new HashMap<>();
        for (Map.Entry<String, Integer> nameEntry : nameMap.entrySet()) {
            result.put(nameEntry.getKey(), row.get(nameEntry.getValue()).getValueAsString());
        }
        return result;
    }

    @Override
    public MySQLColumnData get(int index) {
        return row.get(index);
    }

    @Override
    public int size() {
        return row.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MySQLSimpleRowIndexed that = (MySQLSimpleRowIndexed) o;
        return Objects.equals(nameMap, that.nameMap) &&
                Objects.equals(row, that.row);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), nameMap, row);
    }

    @Override
    public String toString() {
        return "MySQLSimpleRowIndexed{" +
                "nameMap=" + nameMap +
                ", row=" + row +
                '}';
    }
}
