package ru.yandex.direct.binlog.reader;

import java.util.AbstractList;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import ru.yandex.direct.mysql.MySQLSimpleRows;
import ru.yandex.direct.mysql.schema.ColumnSchema;
import ru.yandex.direct.utils.Counter;

public class MySQLSimpleRowsIndexed extends AbstractList<MySQLSimpleRowIndexed> {
    private Map<String, Integer> nameMap;
    private MySQLSimpleRows rows;

    private MySQLSimpleRowsIndexed(Map<String, Integer> nameMap, MySQLSimpleRows rows) {
        this.nameMap = nameMap;
        this.rows = rows;
    }

    public static Map<String, Integer> makeNameMap(Stream<ColumnSchema> columns) {
        Counter counter = new Counter();
        return columns.collect(Collectors.toMap(ColumnSchema::getName, c -> counter.next()));
    }

    public static MySQLSimpleRowsIndexed fromSimpleRows(MySQLSimpleRows rows) {
        return new MySQLSimpleRowsIndexed(makeNameMap(rows.getColumns()), rows);
    }

    @Override
    public MySQLSimpleRowIndexed get(int index) {
        return new MySQLSimpleRowIndexed(nameMap, rows.get(index));
    }

    @Override
    public int size() {
        return rows.size();
    }
}
