package ru.yandex.direct.binlog.reader;

import java.util.Objects;

public class MySQLUpdateRowIndexed {
    private MySQLSimpleRowIndexed before;
    private MySQLSimpleRowIndexed after;

    public MySQLUpdateRowIndexed(MySQLSimpleRowIndexed before, MySQLSimpleRowIndexed after) {
        this.before = before;
        this.after = after;
    }

    public MySQLSimpleRowIndexed getBefore() {
        return before;
    }

    public MySQLSimpleRowIndexed getAfter() {
        return after;
    }

    @Override
    public String toString() {
        return "MySQLUpdateRowIndexed{" +
                "before=" + before +
                ", after=" + after +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MySQLUpdateRowIndexed that = (MySQLUpdateRowIndexed) o;
        return Objects.equals(before, that.before) &&
                Objects.equals(after, that.after);
    }

    @Override
    public int hashCode() {
        return Objects.hash(before, after);
    }
}
