package ru.yandex.direct.binlog.reader;

import java.util.AbstractList;
import java.util.Map;

import ru.yandex.direct.mysql.MySQLUpdateRow;
import ru.yandex.direct.mysql.MySQLUpdateRows;

public class MySQLUpdateRowsIndexed extends AbstractList<MySQLUpdateRowIndexed> {
    private Map<String, Integer> beforeMap;
    private Map<String, Integer> afterMap;
    private MySQLUpdateRows rows;

    private MySQLUpdateRowsIndexed(Map<String, Integer> beforeMap,
                                   Map<String, Integer> afterMap, MySQLUpdateRows rows) {
        this.beforeMap = beforeMap;
        this.afterMap = afterMap;
        this.rows = rows;
    }

    public static MySQLUpdateRowsIndexed fromUpdateRows(MySQLUpdateRows rows) {
        return new MySQLUpdateRowsIndexed(
                MySQLSimpleRowsIndexed.makeNameMap(rows.getBeforeColumns().stream()),
                MySQLSimpleRowsIndexed.makeNameMap(rows.getAfterColumns().stream()),
                rows
        );
    }

    @Override
    public MySQLUpdateRowIndexed get(int index) {
        MySQLUpdateRow row = rows.get(index);
        return new MySQLUpdateRowIndexed(
                new MySQLSimpleRowIndexed(beforeMap, row.getBeforeUpdate()),
                new MySQLSimpleRowIndexed(afterMap, row.getAfterUpdate())
        );
    }

    @Override
    public int size() {
        return rows.size();
    }
}
