package ru.yandex.direct.binlog.reader;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.mysql.MySQLBinlogState;

public class NamedBinlogState {
    private String sourceName;
    private MySQLBinlogState state;

    @JsonCreator
    public NamedBinlogState(
            @JsonProperty("name") String sourceName,
            @JsonProperty("state") MySQLBinlogState state
    ) {
        this.sourceName = sourceName;
        this.state = state;
    }

    @JsonGetter("name")
    public String getSourceName() {
        return sourceName;
    }

    @JsonGetter("state")
    public MySQLBinlogState getState() {
        return state;
    }
}
