package ru.yandex.direct.binlog.reader;

import ru.yandex.direct.mysql.MySQLBinlogState;
import ru.yandex.direct.utils.db.MySQLConnector;

public class StatefulBinlogSource {
    private final BinlogSource source;
    private final MySQLBinlogState state;

    public StatefulBinlogSource(BinlogSource source, MySQLBinlogState state) {
        this.source = source;
        this.state = state;
    }

    public BinlogSource getSource() {
        return source;
    }

    public MySQLBinlogState getState() {
        return state;
    }

    public String getName() {
        return source.getName();
    }

    public MySQLConnector getConnector() {
        return source.getConnector();
    }

}
