package ru.yandex.direct.bsauction;

import com.google.common.base.Joiner;

import static com.google.common.base.Preconditions.checkNotNull;

public class BasicBsRequestPhrase implements BsRequestPhrase {
    private String text;

    private BsRequestPhraseStat stat;

    public BasicBsRequestPhrase withText(String text) {
        this.text = text;
        return this;
    }

    public BasicBsRequestPhrase withStat(BsRequestPhraseStat stat) {
        this.stat = stat;
        return this;
    }

    @Override
    public String getQueryStringValue(int id, long orderId) {
        String ids = checkNotNull(stat, "bs phrase stat query is not defined")
                .getStatQueryText();
        String text = "text:" + this.text;
        return Joiner.on(',').join(Long.toString(id), Long.toString(orderId), "0", text, ids);
    }
}
