package ru.yandex.direct.bsauction;

import java.util.Objects;

import ru.yandex.direct.currency.Money;

public class BsCpcPrice {
    private final Money cpc; // цена клика, то есть сумма, которая реально спишется при попадании баннера на эту позицию
    private final Money price; // ставка, которую нужно поставить, чтобы попасть на эту позицию

    public BsCpcPrice(Money cpc, Money price) {
        this.cpc = cpc;
        this.price = price;
    }

    public Money getCpc() {
        return cpc;
    }

    public Money getPrice() {
        return price;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BsCpcPrice that = (BsCpcPrice) o;
        return Objects.equals(cpc, that.cpc) &&
                Objects.equals(price, that.price);
    }

    @Override
    public int hashCode() {

        return Objects.hash(cpc, price);
    }

    @Override
    public String toString() {
        return "BsCpcPrice{" +
                "cpc=" + cpc +
                ", price=" + price +
                '}';
    }
}
