package ru.yandex.direct.bsauction;

import one.util.streamex.StreamEx;

public abstract class BsRequestPhraseStat {

    public abstract String getStatQueryText();

    public static BsRequestPhraseStat getByForecast(long showsForecastRight, long clicksForecastRight,
                                                    long showsForecastPremium, long clicksForecastPremium) {
        return new BsRequestCalculatedPhraseStat(showsForecastRight, clicksForecastRight,
                showsForecastPremium, clicksForecastPremium);
    }

    public static BsRequestPhraseStat getByHistory(String phraseIdHistoryPrepended) {
        return new BsRequestHistoryPhraseStat(phraseIdHistoryPrepended);
    }

    private static class BsRequestCalculatedPhraseStat extends BsRequestPhraseStat {
        private final long showsForecastRight;
        private final long clicksForecastRight;
        private final long showsForecastPremium;
        private final long clicksForecastPremium;

        public BsRequestCalculatedPhraseStat(long showsForecastRight, long clicksForecastRight,
                                             long showsForecastPremium, long clicksForecastPremium) {
            this.showsForecastRight = showsForecastRight;
            this.clicksForecastRight = clicksForecastRight;
            this.showsForecastPremium = showsForecastPremium;
            this.clicksForecastPremium = clicksForecastPremium;
        }

        public String getStatQueryText() {
            return StreamEx.of(showsForecastRight, clicksForecastRight, showsForecastPremium, clicksForecastPremium)
                    .joining(",", "s:", "");
        }
    }

    private static class BsRequestHistoryPhraseStat extends BsRequestPhraseStat {
        private final String phraseIdHistory;

        public BsRequestHistoryPhraseStat(String phraseIdHistory) {
            this.phraseIdHistory = phraseIdHistory;
        }

        @Override
        public String getStatQueryText() {
            return phraseIdHistory;
        }
    }
}
