package ru.yandex.direct.bsauction;

import java.util.IdentityHashMap;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import static com.google.common.base.Preconditions.checkNotNull;

@SuppressWarnings("WeakerAccess")
@ParametersAreNonnullByDefault
public class BsResponse<T extends BsRequestPhrase, M extends ResponsePhraseWithId> {

    private List<Throwable> errors;
    private IdentityHashMap<T, M> result;

    private BsResponse(List<Throwable> errors) {
        this.errors = errors;
    }

    private BsResponse(IdentityHashMap<T, M> result) {
        this.result = result;
    }

    public boolean isSuccessful() {
        return errors == null;
    }

    @SuppressWarnings("unused")
    @Nullable
    public List<Throwable> getErrors() {
        return errors;
    }

    @SuppressWarnings("unused")
    @Nullable
    public IdentityHashMap<T, M> getSuccessResults() {
        return result;
    }

    public static <T extends BsRequestPhrase, M extends ResponsePhraseWithId> BsResponse<T, M> success(
            IdentityHashMap<T, M> successResult) {
        return new BsResponse<>(successResult);
    }

    @SuppressWarnings("unchecked")
    public static <T extends BsRequestPhrase, M extends ResponsePhraseWithId> BsResponse<T, M> failure(
            List<Throwable> errors) {
        return new BsResponse(checkNotNull(errors, "Error list can't be null"));
    }

    @Override
    public String toString() {
        return "BsResponse{" +
                "errors=" + errors +
                ", result=" + result +
                '}';
    }
}
