package ru.yandex.direct.bsauction;

import java.util.Comparator;

import one.util.streamex.StreamEx;

import ru.yandex.direct.currency.Money;

/**
 * Реализация {@link ResponsePhraseWithId}, в которой доступна только информация о Спецразмещении и Гарантии.
 */
public class PositionalBsTrafaretResponsePhrase implements ResponsePhraseWithId {

    // Наиболее актуальная версия описания полей должна лежать тут https://wiki.yandex-team.ru/Direсt/Auction/
    private int id; // ID переданной фразы
    private BsCpcPrice[] premium; // цены для входа в спецразмещение
    private BsCpcPrice[] guarantee; // цены для входа в гарантию

    @Override
    public int getId() {
        return id;
    }

    public BsCpcPrice[] getPremium() {
        return premium;
    }

    public BsCpcPrice[] getGuarantee() {
        return guarantee;
    }

    // Остальное в трафаретных Торгах не используется

    public Money getMinPrice() {
        return StreamEx.of(getPremium())
                .append(getGuarantee())
                .map(BsCpcPrice::getPrice)
                .min(Comparator.naturalOrder())
                .orElseThrow(() -> new IllegalStateException("Both premium and guarantee are empty"));
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setPremium(BsCpcPrice[] premium) {
        this.premium = premium;
    }

    public void setGuarantee(BsCpcPrice[] guarantee) {
        this.guarantee = guarantee;
    }
}
