package ru.yandex.direct.bsauction.utils;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JsonFormat;

import ru.yandex.yabs.server.proto.rank.TTrafaretRankAnswer;

/**
 * Утилитный класс с методами-помощниками для разбора ответа трафаретных Торгов
 */
public class TrafaretAnswerParsingUtils {

    public static TTrafaretRankAnswer parseJson(String traferetAnswer)
            throws InvalidProtocolBufferException {
        TTrafaretRankAnswer.Builder builder = TTrafaretRankAnswer.newBuilder();
        JsonFormat.parser().merge(traferetAnswer, builder);
        return builder.build();
    }
}
