package ru.yandex.direct.bsexport.messaging;

import java.util.StringJoiner;

import com.google.protobuf.util.JsonFormat;

import ru.yandex.adv.direct.expression.TargetingExpression;
import ru.yandex.adv.direct.expression.TargetingExpressionAtom;
import ru.yandex.direct.bsexport.model.Order;

import static com.google.common.base.CaseFormat.LOWER_HYPHEN;
import static com.google.common.base.CaseFormat.UPPER_CAMEL;

public class FeedJsonSerializer {

    public static final JsonFormat.TypeRegistry TYPE_REGISTRY = JsonFormat.TypeRegistry.newBuilder()
            .add(Order.getDescriptor())
            .build();
    private static final JsonFormat.Printer printer = JsonFormat.printer()
            .usingTypeRegistry(TYPE_REGISTRY)
            .preservingProtoFieldNames();

    private FeedJsonSerializer() {
    }

    public static JsonFormat.Printer getPrinter() {
        return printer.omittingInsignificantWhitespace();
    }

    // package-private: для тестов на совместимость со старыми данными
    static String expressionOldStyleSerializer(TargetingExpression expression) {
        StringJoiner result = jsonArray();

        for (var disjunction : expression.getANDList()) {
            StringJoiner joiner = jsonArray();
            for (var atom : disjunction.getORList()) {
                joiner.add(expressionAtomOldStyleSerializer(atom));
            }
            result.add(joiner.toString());
        }

        return result.toString();
    }

    private static String expressionAtomOldStyleSerializer(TargetingExpressionAtom expressionAtom) {
        String keyword = UPPER_CAMEL.to(LOWER_HYPHEN, expressionAtom.getKeyword().name().replace("ID", "Id"));
        String operation = UPPER_CAMEL.to(LOWER_HYPHEN, expressionAtom.getOperation().name()).replace('-', ' ');
        return jsonArray()
                .add('"' + keyword + '"')
                .add('"' + operation + '"')
                .add('"' + expressionAtom.getValue() + '"')
                .toString();
    }

    private static StringJoiner jsonArray() {
        return new StringJoiner(",", "[", "]");
    }
}
