package ru.yandex.direct.bsexport.messaging;

import java.util.HashMap;
import java.util.Map;

import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;

import ru.yandex.direct.bsexport.messaging.processors.ResponseProcessor;
import ru.yandex.direct.bsexport.model.SoapFault;
import ru.yandex.direct.bsexport.model.UpdateData2Response;

import static com.google.common.base.Preconditions.checkState;


public class SoapResponseDeserializer {

    private final SOAPBody soapBody;

    public SoapResponseDeserializer(SOAPMessage soapMessage) throws SOAPException {
        this.soapBody = soapMessage.getSOAPBody();
    }

    public boolean hasFault() {
        return soapBody.hasFault();
    }

    public SoapFault getFault() {
        checkState(hasFault());

        SOAPFault fault = soapBody.getFault();

        Map<String, String> details = new HashMap<>();
        if (fault.hasDetail()) {
            fault.getDetail()
                    .getDetailEntries()
                    .forEachRemaining(e -> details.put(
                            e.getNodeName(),
                            e.getTextContent().trim().replaceAll("\\n +", "\n")));
        }
        return new SoapFault()
                .withFaultCode(fault.getFaultCode())
                .withFaultString(fault.getFaultString())
                .withFaultDetails(details);
    }


    public UpdateData2Response deserialize() {
        checkState(!hasFault());

        ResponseProcessor ds = new ResponseProcessor();
        ds.processFields(soapBody);
        return ds.getResult();
    }
}


