package ru.yandex.direct.bsexport.messaging.processors;

import java.util.Map;

import ru.yandex.direct.bsexport.messaging.FieldNames;
import ru.yandex.direct.bsexport.model.BannerResponse;

class BannerProcessor extends Processor<BannerResponse.Builder> {

    private static final Map<String, FieldProcessor<BannerResponse.Builder, ?>> PROCESSORS = Map.of(
            FieldNames.EID, new LongFieldProcessor<>(BannerResponse.Builder::setEID),
            FieldNames.ID, new LongFieldProcessor<>(BannerResponse.Builder::setID),
            FieldNames.STOP, new BooleanFieldProcessor<>(BannerResponse.Builder::setStop),
            FieldNames.ERROR, new BooleanFieldProcessor<>(BannerResponse.Builder::setError),
            FieldNames.ERROR_MESSAGE, new StringFieldProcessor<>(BannerResponse.Builder::setErrorMessage)
    );

    BannerProcessor() {
        super(BannerResponse::newBuilder, PROCESSORS);
    }

    BannerResponse getResult() {
        return builder.build();
    }

}
