package ru.yandex.direct.bsexport.messaging.processors;

import java.util.function.BiFunction;

import org.w3c.dom.Node;

class BooleanFieldProcessor<B> extends FieldProcessor<B, Boolean> {
    BooleanFieldProcessor(BiFunction<B, Boolean, B> setter) {
        super(setter, BooleanFieldProcessor::parseBoolean);
    }

    private static boolean parseBoolean(Node node) {
        switch (node.getTextContent()) {
            case "1":
                return true;
            case "0":
                return false;
            default:
                throw new IllegalStateException("Can't parse content of " + node.getNodeName()
                        + "('" + node.getTextContent() + "') as boolean");
        }
    }
}
