package ru.yandex.direct.bsexport.messaging.processors;

import java.util.Map;
import java.util.function.Consumer;

import org.w3c.dom.Node;

import ru.yandex.direct.bsexport.messaging.FieldNames;
import ru.yandex.direct.bsexport.model.DynamicResponse;

/**
 * Обработчик GOAL_CONTEXT.
 * Ответ БК - это Map, в котором перечислены item с key и value (id, eid).
 * У фейковой БК (наша песочница) это структура, где лежат готовые структуры с eid/id.
 */
class DynamicProcessor extends Processor<DynamicResponse.Builder> {

    private static final Map<String, FieldProcessor<DynamicResponse.Builder, ?>> PROCESSORS = Map.of(
            FieldNames.EID, new LongFieldProcessor<>(DynamicResponse.Builder::setEID),
            FieldNames.ID, new UnsignedLongFieldProcessor<>(DynamicResponse.Builder::setID)
    );

    private String key;

    DynamicProcessor() {
        super(DynamicResponse::newBuilder, PROCESSORS);
    }

    @Override
    public void processFields(Node fieldNode) {
        if (fieldNode.getNodeName().equals("key")) {
            // тут ставится название ключа для продакшена
            // не через getChildFieldsProcessor, так как там пропускаются ноды типа TEXT_NODE
            key = fieldNode.getTextContent();
        } else {
            super.processFields(fieldNode);
        }
    }

    @Override
    Consumer<Node> getChildFieldsProcessor(String nodeName) {
        if (nodeName.equals("value")) {
            return this::processFields;
        }
        return Processor::doNothing;
    }

    DynamicResponse getResult() {
        return builder.build();
    }

    String getKey() {
        return key;
    }
}
