package ru.yandex.direct.bsexport.messaging.processors;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FieldProcessor<B, T> {
    private final BiFunction<B, T, B> setter;
    private final Function<Node, T> converter;

    FieldProcessor(BiFunction<B, T, B> setter, Function<Node, T> converter) {
        this.setter = setter;
        this.converter = converter;
    }

    void setField(B builder, Node node) {
        if (node.getAttributes().getNamedItem("xsi:null") != null) {
            return;
        }
        T value = converter.apply(node);
        setter.apply(builder, value);
    }

    static void processEachChildNode(Node node, Consumer<Node> consumer) {
        NodeList childNodes = node.getChildNodes();
        for (int fieldIndex = 0; fieldIndex < childNodes.getLength(); fieldIndex++) {
            Node childNode = childNodes.item(fieldIndex);
            if (childNode.getNodeType() == Node.TEXT_NODE) {
                continue;
            }
            consumer.accept(childNode);
        }
    }
}
