package ru.yandex.direct.bsexport.messaging.processors;

import java.util.Map;
import java.util.function.Consumer;

import org.w3c.dom.Node;

import ru.yandex.direct.bsexport.messaging.FieldNames;
import ru.yandex.direct.bsexport.model.RetargetingResponse;

/**
 * Обработчик GOAL_CONTEXT.
 * Ответ БК - это Map, в котором перечислены item с key и value (id, eid).
 * У фейковой БК (наша песочница) это структура, где лежат готовые структуры с eid/id.
 */
class GoalContextProcessor extends Processor<RetargetingResponse.Builder> {

    private static final Map<String, FieldProcessor<RetargetingResponse.Builder, ?>> PROCESSORS = Map.of(
            FieldNames.EID, new LongFieldProcessor<>(RetargetingResponse.Builder::setEID),
            FieldNames.ID, new UnsignedLongFieldProcessor<>(RetargetingResponse.Builder::setID)
    );

    private String key;

    GoalContextProcessor() {
        super(RetargetingResponse::newBuilder, PROCESSORS);
    }

    @Override
    public void processFields(Node fieldNode) {
        if (fieldNode.getNodeName().equals("key")) {
            // тут ставится название ключа для продакшена
            // не через getChildFieldsProcessor, так как там пропускаются ноды типа TEXT_NODE
            key = fieldNode.getTextContent();
        } else {
            super.processFields(fieldNode);
        }
    }

    @Override
    Consumer<Node> getChildFieldsProcessor(String nodeName) {
        if (nodeName.equals("value")) {
            return this::processFields;
        }
        return Processor::doNothing;
    }

    RetargetingResponse getResult() {
        return builder.build();
    }

    String getKey() {
        return key;
    }
}
