package ru.yandex.direct.bsexport.messaging.processors;

import java.util.function.BiFunction;

import org.w3c.dom.Node;

class LongFieldProcessor<B> extends FieldProcessor<B, Long> {

    LongFieldProcessor(BiFunction<B, Long, B> setter) {
        super(setter, LongFieldProcessor::parseLong);
    }

    private static long parseLong(Node node) {
        return Long.parseLong(node.getTextContent());
    }
}
