package ru.yandex.direct.bsexport.messaging.processors;

import java.util.Map;
import java.util.function.Consumer;

import org.w3c.dom.Node;

import ru.yandex.direct.bsexport.messaging.FieldNames;
import ru.yandex.direct.bsexport.model.OrderResponse;

import static ru.yandex.direct.bsexport.messaging.processors.FieldProcessor.processEachChildNode;

class OrderProcessor extends Processor<OrderResponse.Builder> {

    private static final Map<String, FieldProcessor<OrderResponse.Builder, ?>> PROCESSORS = Map.of(
            FieldNames.EID, new LongFieldProcessor<>(OrderResponse.Builder::setEID),
            FieldNames.ID, new LongFieldProcessor<>(OrderResponse.Builder::setID),
            FieldNames.STOP, new BooleanFieldProcessor<>(OrderResponse.Builder::setStop),
            FieldNames.ARCHIVE, new BooleanFieldProcessor<>(OrderResponse.Builder::setArchive),
            FieldNames.UNDONE, new BooleanFieldProcessor<>(OrderResponse.Builder::setUnDone),
            FieldNames.ERROR, new BooleanFieldProcessor<>(OrderResponse.Builder::setError),
            FieldNames.ERROR_MESSAGE, new StringFieldProcessor<>(OrderResponse.Builder::setErrorMessage)
    );

    OrderProcessor() {
        super(OrderResponse::newBuilder, PROCESSORS);
    }

    @Override
    Consumer<Node> getChildFieldsProcessor(String nodeName) {
        switch (nodeName) {
            case FieldNames.CONTEXT:
                return this::processContext;

            default:
                return Processor::doNothing;
        }
    }

    private void processContext(Node contextNode) {
        var processor = new ContextProcessor();
        processEachChildNode(contextNode, processor::processFields);
        builder.putCONTEXT(contextNode.getNodeName(), processor.getResult());
    }

    OrderResponse getResult() {
        return builder.build();
    }
}
