package ru.yandex.direct.bsexport.messaging.processors;

import java.util.Map;

import ru.yandex.direct.bsexport.messaging.FieldNames;
import ru.yandex.direct.bsexport.model.PhraseResponse;

class PhraseProcessor extends Processor<PhraseResponse.Builder> {

    private static final Map<String, FieldProcessor<PhraseResponse.Builder, ?>> PROCESSORS = Map.of(
            FieldNames.EID, new LongFieldProcessor<>(PhraseResponse.Builder::setEID),
            FieldNames.ID, new UnsignedLongFieldProcessor<>(PhraseResponse.Builder::setID),
            FieldNames.ERROR, new BooleanFieldProcessor<>(PhraseResponse.Builder::setError),
            FieldNames.ERROR_MESSAGE, new StringFieldProcessor<>(PhraseResponse.Builder::setErrorMessage)
    );

    PhraseProcessor() {
        super(PhraseResponse::newBuilder, PROCESSORS);
    }

    PhraseResponse getResult() {
        return builder.build();
    }
}
