package ru.yandex.direct.bsexport.messaging.processors;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

import org.w3c.dom.Node;

abstract class Processor<B> {

    private final Map<String, FieldProcessor<B, ?>> fieldProcessors;
    protected final B builder;

    Processor(Supplier<B> builderSupplier, Map<String, FieldProcessor<B, ?>> fieldProcessors) {
        this.fieldProcessors = fieldProcessors;
        builder = builderSupplier.get();
    }

    Consumer<Node> getChildFieldsProcessor(String nodeName) {
        return Processor::doNothing;
    }

    public void processFields(Node fieldNode) {
        String nodeName = fieldNode.getNodeName();

        var processor = fieldProcessors.get(nodeName);
        if (processor != null) {
            processor.setField(builder, fieldNode);
            return;
        }

        Consumer<Node> childFieldsProcessor = getChildFieldsProcessor(nodeName);
        FieldProcessor.processEachChildNode(fieldNode, childFieldsProcessor);
    }

    static void doNothing(Node ignored) {
    }
}
