package ru.yandex.direct.bsexport.messaging.processors;

import java.util.Map;
import java.util.function.Consumer;

import org.w3c.dom.Node;

import ru.yandex.direct.bsexport.messaging.FieldNames;
import ru.yandex.direct.bsexport.model.UpdateData2Response;

public class ResponseProcessor extends Processor<UpdateData2Response.Builder> {

    private static final Map<String, FieldProcessor<UpdateData2Response.Builder, ?>> PROCESSORS = Map.of(
            FieldNames.BACKEND_HOST, new StringFieldProcessor<>(UpdateData2Response.Builder::setBACKENDHOST),
            FieldNames.UNDONE, new BooleanFieldProcessor<>(UpdateData2Response.Builder::setUnDone),
            FieldNames.ERROR, new BooleanFieldProcessor<>(UpdateData2Response.Builder::setError),
            FieldNames.ERROR_MESSAGE, new StringFieldProcessor<>(UpdateData2Response.Builder::setErrorMessage)
    );

    public ResponseProcessor() {
        super(UpdateData2Response::newBuilder, PROCESSORS);
    }

    @Override
    Consumer<Node> getChildFieldsProcessor(String nodeName) {
        switch (nodeName) {
            case FieldNames.ORDER:
                return this::processOrder;
            default:
                return this::processFields;
        }
    }

    public UpdateData2Response getResult() {
        return builder.build();
    }

    private void processOrder(Node orderNode) {
        var processor = new OrderProcessor();
        FieldProcessor.processEachChildNode(orderNode, processor::processFields);
        builder.putORDER(orderNode.getNodeName(), processor.getResult());
    }
}

